#include "oloption.h"
#include "resource.h"

char theinifile[256];

// Interactive Part: The Tab Window handler
//
BOOL APIENTRY TabHandler (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	int enabletransparency;
	int transparencystyle;
	try {
		switch(uMsg) {
		case WM_INITDIALOG:
		{
			sprintf(theinifile,"%s\\oloadset.ini",myappdir);

			enabletransparency = GetPrivateProfileInt("SETTINGS","overload_enabletransparency",1,theinifile);
			SendMessage(GetDlgItem(hDlg, IDC_ENABLETRANSP), BM_SETCHECK, (WPARAM)(enabletransparency), 0L);

			transparencystyle = GetPrivateProfileInt("SETTINGS","overload_transparencystyle",0,theinifile);
			SendMessage(GetDlgItem(hDlg, IDC_TRANSSTYLE), CB_RESETCONTENT, 0, 0);
			SendMessage(GetDlgItem(hDlg, IDC_TRANSSTYLE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("Active Full\\Inactive Faded"));
			SendMessage(GetDlgItem(hDlg, IDC_TRANSSTYLE), CB_SETCURSEL, (int)(transparencystyle), 0);

			return 1;
		}
		case WM_SHOWWINDOW:
		{
			return 1;
		}
		case WM_CLOSE:
		{
			EndDialog (hDlg, TRUE);
		}
		case SaveChanges:
		{
			char bufr[256];

			enabletransparency = (int)SendMessage(GetDlgItem(hDlg, IDC_ENABLETRANSP), BM_GETCHECK, 0, 0L);
			sprintf(bufr,"%i",enabletransparency);
			WritePrivateProfileString("SETTINGS","overload_enabletransparency",bufr,theinifile);
			transparencystyle = (int)SendMessage(GetDlgItem(hDlg, IDC_TRANSSTYLE), CB_GETCURSEL, 0, 0);
			sprintf(bufr,"%i",transparencystyle);
			WritePrivateProfileString("SETTINGS","overload_transparencystyle",bufr,theinifile);

			return 1;
		}
		default:
			return 0;
		}
	} catch (...) { }
	return 0;
}


// Paperwork part: Tabs paperwork
//
bool GetTabs(int index, HWND parentwindow, HWND * tabwindow, char * tabtitle) {
	switch (index) {
	case 0:
		sprintf(tabtitle, "Transparency");
		*tabwindow = CreateDialog(dllInstance, MAKEINTRESOURCE (IDD_TRANSTAB), parentwindow, TabHandler);
		return true;
	default:
		return false;
	}
}